<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cat extends CI_Controller {

	function __Construct(){
		parent:: __Construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->model('m_cat');
	}

	public function index(){
		if($this->session->userdata('peserta')!=null){
			redirect(base_url('ujian'));
		}

		$data['title']="CAT";
		
		$this->load->view('home',$data);
	}

	function cari_jumlah(){
		$pin=$this->input->get('pin',TRUE);
		$jlh_peserta=$this->m_cat->hitung_peserta($pin);

		echo $jlh_peserta->num_rows();
	}

	function cek_peserta(){
		$no_ujian=$this->input->post('no_ujian',TRUE);
		$pin=$this->input->post('pin_sesi',TRUE);

		$cek_no_ujian=$this->m_cat->m_data('peserta',['no_ujian'=>$no_ujian]);
		if($cek_no_ujian->num_rows()>0){
			$cek_pin=$this->m_cat->m_data('jadwal',['pin'=>$pin]);
			if($cek_pin->num_rows()>0){				

				$cek_jam=$cek_pin->result();

				$jam_mulai_terlambat=date('Y-m-d H:i:s',strtotime("+10 minutes",strtotime($cek_jam[0]->tanggal_jam)));

				$cek_login=$this->m_cat->m_data('selesai',['pin'=>$pin,'no_ujian'=>$no_ujian]);

				if(date('Y-m-d H:i:s') > $jam_mulai_terlambat){
					echo "Tidak bisa ujian karena anda sudah terlambat";
				}
				elseif(@$cek_login->result()[0]->ket=='Selesai'){
					echo "Anda sudah selesai ujian";
				}
				else{

					$result=$cek_no_ujian->result();
					$result_sesi=$cek_pin->result();
					$sesi['peserta']=array(
							'id'=>$result[0]->id,
							'no_ujian'=>$result[0]->no_ujian,
							'nama'=>$result[0]->nama,
							'tempat'=>$result[0]->tempat,
							'tgl_lahir'=>$result[0]->tgl_lahir,
							'asal_ujian'=>$result[0]->asal_ujian,
							'pendidikan'=>$result[0]->pendidikan,
							'pin'=>$result_sesi[0]->pin,
							'kategori'=>$result[0]->kategori,
							'bidang_soal'=>$result_sesi[0]->bidang_soal,
							'jlh_soal'=>$result_sesi[0]->jlh_soal,
							'jam_mulai'=>$result_sesi[0]->tanggal_jam,
							'lama_ujian'=>$result_sesi[0]->lama_ujian,
						);

					if(@$cek_login->result()[0]->soal != ""){
						$sesi['sesisoal']=$cek_login->result()[0]->soal;
					}

					$this->session->set_userdata($sesi);

					echo "OK";
				}
			}
			else{
				echo "PIN sesi salah";
			}
		}
		else{
			echo "Nomor ujian salah";
		}
	}

	function batal_ujian(){
		$no_ujian=$this->cek_sesi()['no_ujian'];
		$pin=$this->cek_sesi()['pin'];
		
		$this->m_cat->delete('selesai',['no_ujian'=>$no_ujian,'pin'=>$pin]);

		$this->session->unset_userdata('peserta');
		$this->session->unset_userdata('sesisoal');
		$this->session->unset_userdata('ujian');
	}

	function bio_peserta(){
		if($this->session->userdata('ujian')!=null){
			redirect(base_url('ujian'));
		}

		$data['title']="Biodata Peserta";
		$this->load->view('bio_peserta',$data);
	}

	function c(){
		print_r($this->session->userdata());
	}

	function ujian(){
		$data['title']="Ujian";
		$data['kategori']=$this->cek_sesi('peserta')['kategori'];
		$data['bidang_soal']=$this->cek_sesi('peserta')['bidang_soal'];
		$data['jumlah']=$this->cek_sesi('peserta')['jlh_soal'];
		$data['no_ujian']=$this->cek_sesi()['no_ujian'];
		$data['pendidikan']=$this->cek_sesi()['pendidikan'];

		$id_soal_sesi=$this->session->userdata('sesisoal');
		if($id_soal_sesi == null){
			$data['soal']=$this->m_cat->m_soal('',$data['kategori'],$data['bidang_soal'],$data['jumlah'],$data['pendidikan']);

			$soalToSesi=[];
			foreach($data['soal']->result() as $sesisoal){
				$soalToSesi[]=$sesisoal->id;
			}

			$setkesesi['sesisoal']=implode(",", $soalToSesi);

			$mulai=[
				'pin'=>$this->cek_sesi('peserta')['pin'],
				'waktu_mulai'=>date('Y-m-d H:i:s'),
				'no_ujian'=>$data['no_ujian'],
				'soal'=>$setkesesi['sesisoal'],
			];
			$this->m_cat->insert('selesai',$mulai);
		}
		else{

			$data['soal']=$this->m_cat->m_soal($id_soal_sesi,'','','');
		}

		if(empty($this->session->userdata('ujian')['jam_ahir'])){
			$setkesesi['ujian']=array('jam_ahir'=>date('Y-m-d H:i:s',strtotime("+".$this->session->userdata('peserta')['lama_ujian']." minutes")));
		}
		
		if(isset($setkesesi)){
			$this->session->set_userdata($setkesesi);
		}

		$this->load->view('ujian',$data);
	}

	function simpan_jawaban(){
		$id=$this->input->get('id');
		$jawab=$this->input->post('jawab');
		$no_ujian=$this->cek_sesi()['no_ujian'];
		$pin=$this->cek_sesi()['pin'];

		$nilai=$this->m_cat->m_data('soal',['id'=>$id])->result();

		$kolom="nilai_$jawab";

		$data=array(
				'pin'=>$pin,
				'waktu'=>date('Y-m-d H:i:s'),
				'no_ujian'=>$no_ujian,
				'bidang_soal'=>$nilai[0]->bidang_soal,
				'id_soal'=>$id,
				'jawab'=>$jawab,
				'nilai'=>$nilai[0]->$kolom,
			);

		$cek_update_jawaban=$this->m_cat->m_data('jawaban',['id_soal'=>$id,'no_ujian'=>$no_ujian]);

		if($cek_update_jawaban->num_rows() == 0){
			$this->m_cat->insert('jawaban',$data);
		}
		else{
			$update_jawaban=$cek_update_jawaban->result();
			$id_jawaban=$update_jawaban[0]->id;

			$this->m_cat->update('jawaban',['id'=>$id_jawaban],$data);
		}

		echo "OK";
	}

	function hasil(){
		$data['title']="Biodata Peserta";
		$this->load->view('bio_peserta',$data);
	}

	function cek_sesi(){
		if($this->session->userdata('peserta')['id']==""){
			redirect(base_url());
		}

		return $this->session->userdata('peserta');
	}

	function load_hasil_ujian(){
		$no_ujian=$this->session->userdata('peserta')['no_ujian'];
		$bidang_soal=$this->session->userdata('peserta')['bidang_soal'];
		$pin=$this->session->userdata('peserta')['pin'];
		$hasil=$this->m_cat->m_hasil_ujian($no_ujian,$bidang_soal)->result();

		echo '<p>Rekap Hasil Ujian</p>';
		echo '<table class="" width="300">';
			$tot=0;
			foreach($hasil as $nilai){
				$tot+=$nilai->nilai;
				echo '
					<tr>
						<th>'.$nilai->bidang_soal.'</th>
						<td>'.$nilai->nilai.'</td>
					</tr>
				';
			}
		echo '
			<tr>
				<th><hr>Total</th>
				<td><hr>'.$tot.'</td>
			</tr>
		';
		echo '</table>';
		$selesai=[
				'waktu_selesai'=>date('Y-m-d H:i:s'),
				'ket'=>'Selesai',
			];
		$this->m_cat->update('selesai',['pin'=>$pin,'no_ujian'=>$no_ujian],$selesai);

		$this->session->unset_userdata('peserta');
		$this->session->unset_userdata('ujian');
		$this->session->unset_userdata('sesisoal');
	}

	function live_score(){
		$data['title']="Live Score";
		$this->load->view('live_score',$data);
		$this->session->unset_userdata('sesi_live');
	}

	function tampil_data_live(){
		$data['title']="Live Score";

		if($this->session->userdata('sesi_live')==null){
			$pin=$this->input->get('pin');	
			$data['ujian']=$this->m_cat->m_data('jadwal',['pin'=>$pin])->result_array();
			$bidang_soal=$data['ujian'][0]['bidang_soal'];
			$data['nama_ujian']=$data['ujian'][0]['ujian'];

			$set_sesi['sesi_live']=$data['ujian'][0];
			$this->session->set_userdata($set_sesi);
		}
		else{
			$pin=$this->session->userdata('sesi_live')['pin'];
			$bidang_soal=$this->session->userdata('sesi_live')['bidang_soal'];
			$data['nama_ujian']=$this->session->userdata('sesi_live')['ujian'];
		}
		$data['bidang_soal']=$bidang_soal;

		$data['live']=$this->m_cat->data_live($pin,$bidang_soal);
		$this->load->view('live_data',$data);
	}
}
